/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.potion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.recipe.EffectHolder;

public class ItemAlchemyFlask
extends Item {
    public ItemAlchemyFlask() {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB).m_41503_(8));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.arctool.uses", new Object[]{this.getRemainingUses(stack)}).m_130940_(ChatFormatting.GOLD));
        PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)1.0f);
    }

    public int getRemainingUses(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public void resyncEffectInstances(ItemStack stack) {
        List<EffectHolder> holderList = this.getEffectHoldersOfFlask(stack);
        ArrayList<MobEffectInstance> effectList = new ArrayList<MobEffectInstance>();
        for (EffectHolder holder : holderList) {
            effectList.add(holder.getEffectInstance(false, true));
        }
        this.setEffectsOfFlask(stack, effectList);
    }

    public ItemStack setEffectsOfFlask(ItemStack stack, Collection<MobEffectInstance> effects) {
        if (effects.isEmpty()) {
            return stack;
        }
        CompoundTag compoundnbt = stack.m_41784_();
        ListTag listnbt = new ListTag();
        for (MobEffectInstance effectinstance : effects) {
            listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
        }
        compoundnbt.m_128365_("CustomPotionEffects", (Tag)listnbt);
        return stack;
    }

    public void setEffectHoldersOfFlask(ItemStack stack, List<EffectHolder> effects) {
        if (effects.isEmpty()) {
            return;
        }
        CompoundTag compoundnbt = stack.m_41784_();
        ListTag listnbt = new ListTag();
        for (EffectHolder effectHolder : effects) {
            listnbt.add((Object)effectHolder.write(new CompoundTag()));
        }
        compoundnbt.m_128365_("effectholder", (Tag)listnbt);
    }

    public List<EffectHolder> getEffectHoldersOfFlask(ItemStack stack) {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        CompoundTag tag = stack.m_41783_();
        ListTag tags = tag.m_128437_("effectholder", 10);
        if (tags.isEmpty()) {
            return holderList;
        }
        for (int i = 0; i < tags.size(); ++i) {
            CompoundTag newTag = tags.m_128728_(i);
            EffectHolder holder = EffectHolder.read(newTag);
            if (holder == null) continue;
            holderList.add(holder);
        }
        return holderList;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldStack = playerIn.m_21120_(handIn);
        if (this.getRemainingUses(heldStack) <= 0) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        return ItemUtils.m_150959_((Level)worldIn, (Player)playerIn, (InteractionHand)handIn);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player playerentity;
        Player player = playerentity = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (playerentity instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)playerentity, stack);
        }
        if (!worldIn.f_46443_) {
            for (MobEffectInstance effectinstance : PotionUtils.m_43547_((ItemStack)stack)) {
                if (effectinstance.m_19544_().m_8093_()) {
                    effectinstance.m_19544_().m_19461_((Entity)playerentity, (Entity)playerentity, entityLiving, effectinstance.m_19564_(), 1.0);
                    continue;
                }
                entityLiving.m_7292_(new MobEffectInstance(effectinstance));
            }
        }
        if (playerentity != null) {
            playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!playerentity.m_150110_().f_35937_) {
                stack.m_41721_(stack.m_41773_() + 1);
            }
        }
        return stack;
    }
}

